//*****************************************************************************
//*****************************************************************************
//  FILENAME: PWM16_SERVO.h
//   Version: 2.4, Updated on 2004/10/27 at 18:26:14
//  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
//
//  DESCRIPTION: PWM16 User Module C Language interface file
//               for the 22/24/27/29xxx PSoC family of devices
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

#pragma fastcall16 PWM16_SERVO_EnableInt
#pragma fastcall16 PWM16_SERVO_DisableInt
#pragma fastcall16 PWM16_SERVO_Start
#pragma fastcall16 PWM16_SERVO_Stop
#pragma fastcall16 PWM16_SERVO_wReadCounter              // Read  DR0
#pragma fastcall16 PWM16_SERVO_WritePeriod               // Write DR1
#pragma fastcall16 PWM16_SERVO_wReadPulseWidth           // Read  DR2
#pragma fastcall16 PWM16_SERVO_WritePulseWidth           // Write DR2

// The following symbols are deprecated.
// They may be omitted in future releases
//
#pragma fastcall16 wPWM16_SERVO_ReadCounter              // Read  DR0 (Deprecated)
#pragma fastcall16 wPWM16_SERVO_ReadPulseWidth           // Read  DR2 (Deprecated)


//-------------------------------------------------
// Prototypes of the PWM16_SERVO API.
//-------------------------------------------------

extern void PWM16_SERVO_EnableInt(void);                  // Proxy Class 1
extern void PWM16_SERVO_DisableInt(void);                 // Proxy Class 1
extern void PWM16_SERVO_Start(void);                      // Proxy Class 1
extern void PWM16_SERVO_Stop(void);                       // Proxy Class 1
extern WORD PWM16_SERVO_wReadCounter(void);               // Proxy Class 2
extern void PWM16_SERVO_WritePeriod(WORD wPeriod);        // Proxy Class 1
extern WORD PWM16_SERVO_wReadPulseWidth(void);            // Proxy Class 1
extern void PWM16_SERVO_WritePulseWidth(WORD wPulseWidth);// Proxy Class 1

// The following functions are deprecated.
// They may be omitted in future releases
//
extern WORD wPWM16_SERVO_ReadCounter(void);            // Deprecated
extern WORD wPWM16_SERVO_ReadPulseWidth(void);         // Deprecated


//-------------------------------------------------
// Constants for PWM16_SERVO API's.
//-------------------------------------------------

#define PWM16_SERVO_CONTROL_REG_START_BIT      ( 0x01 )
#define PWM16_SERVO_INT_REG_ADDR               ( 0x0df )
#define PWM16_SERVO_INT_MASK                   ( 0x20 )


//--------------------------------------------------
// Constants for PWM16_SERVO user defined values
//--------------------------------------------------

#define PWM16_SERVO_PERIOD                     ( 0xfffe )
#define PWM16_SERVO_PULSE_WIDTH                ( 0x0 )


//-------------------------------------------------
// Register Addresses for PWM16_SERVO
//-------------------------------------------------

#pragma ioport  PWM16_SERVO_COUNTER_LSB_REG:    0x050      //DR0 Count register LSB
BYTE            PWM16_SERVO_COUNTER_LSB_REG;
#pragma ioport  PWM16_SERVO_COUNTER_MSB_REG:    0x054      //DR0 Count register MSB
BYTE            PWM16_SERVO_COUNTER_MSB_REG;
#pragma ioport  PWM16_SERVO_PERIOD_LSB_REG: 0x051          //DR1 Period register LSB
BYTE            PWM16_SERVO_PERIOD_LSB_REG;
#pragma ioport  PWM16_SERVO_PERIOD_MSB_REG: 0x055          //DR1 Period register MSB
BYTE            PWM16_SERVO_PERIOD_MSB_REG;
#pragma ioport  PWM16_SERVO_COMPARE_LSB_REG:    0x052      //DR2 Compare register LSB
BYTE            PWM16_SERVO_COMPARE_LSB_REG;
#pragma ioport  PWM16_SERVO_COMPARE_MSB_REG:    0x056      //DR2 Compare register MSB
BYTE            PWM16_SERVO_COMPARE_MSB_REG;
#pragma ioport  PWM16_SERVO_CONTROL_LSB_REG:    0x053      //Control register LSB
BYTE            PWM16_SERVO_CONTROL_LSB_REG;
#pragma ioport  PWM16_SERVO_CONTROL_MSB_REG:    0x057      //Control register MSB
BYTE            PWM16_SERVO_CONTROL_MSB_REG;
#pragma ioport  PWM16_SERVO_FUNC_LSB_REG:   0x150          //Function register LSB
BYTE            PWM16_SERVO_FUNC_LSB_REG;
#pragma ioport  PWM16_SERVO_FUNC_MSB_REG:   0x154          //Function register MSB
BYTE            PWM16_SERVO_FUNC_MSB_REG;
#pragma ioport  PWM16_SERVO_INPUT_LSB_REG:  0x151          //Input register LSB
BYTE            PWM16_SERVO_INPUT_LSB_REG;
#pragma ioport  PWM16_SERVO_INPUT_MSB_REG:  0x155          //Input register MSB
BYTE            PWM16_SERVO_INPUT_MSB_REG;
#pragma ioport  PWM16_SERVO_OUTPUT_LSB_REG: 0x152          //Output register LSB
BYTE            PWM16_SERVO_OUTPUT_LSB_REG;
#pragma ioport  PWM16_SERVO_OUTPUT_MSB_REG: 0x156          //Output register MSB
BYTE            PWM16_SERVO_OUTPUT_MSB_REG;
#pragma ioport  PWM16_SERVO_INT_REG:       0x0df           //Interrupt Mask Register
BYTE            PWM16_SERVO_INT_REG;


//-------------------------------------------------
// PWM16_SERVO Macro 'Functions'
//-------------------------------------------------

#define PWM16_SERVO_Start_M \
   ( PWM16_SERVO_CONTROL_LSB_REG |=  PWM16_SERVO_CONTROL_REG_START_BIT )

#define PWM16_SERVO_Stop_M  \
   ( PWM16_SERVO_CONTROL_LSB_REG &= ~PWM16_SERVO_CONTROL_REG_START_BIT )

#define PWM16_SERVO_EnableInt_M   \
   M8C_EnableIntMask(  PWM16_SERVO_INT_REG, PWM16_SERVO_INT_MASK )

#define PWM16_SERVO_DisableInt_M  \
   M8C_DisableIntMask( PWM16_SERVO_INT_REG, PWM16_SERVO_INT_MASK )

// end of file PWM16_SERVO.h
